capture log close
prog drop _all
set more off
set trace off
pause on
#delimit ;
clear;

global dir "D:\RA\Moffitt\Nicole_LS\091712";


/*
-Nicole
This program generate 14 different graphs, including 
EPOP for the entire population, EPOP by Education, By Age, By Race and Gender, 
By education for ages 16 to 24, By education for ages 25 to 39, 
By education for ages 40 to 54, By education for ages 55 to 64, By education for ages 65+, 
By race and gender for each of these 5 age groups separately
-Lu 120723
1. Employment-Population Ratio for the U.S. Civilian Noninstitutional Population,
1970-2011 
Show the total and also separately by gender.
Put a vertical line in at 2000 and at 2007.
2. Employment-Population Ratio for the U.S. Civilian Noninstitutional Population
16-64 and National Unemployment Rate, 1989-2011
16-64, 1989-2011.
Plot the national unemployment rate, too.  That should be on the Right axis.  
Put vertical lines at 1989, 1999, and 2007.
3.  Actual and Hypothetical Employment-Population Ratio with Fixed 1999 
Demographic Composition, 1989-2011
Show the figure in the attached Excel file, which Nicole did.  
But don't have the identification of each line down at the bottom--
put those labels in the graph itself, close to their corresponding lines.  
Or even arrows.  Also, add a footnote saying "Fixed-Composition calculated by 
fixing 1999 age, gender, education, and race proportions."
*/
/*Figure1*/

/*
use $dir\BLS_byGender.dta, clear;
rename annual_men empMen;
rename annual_women empWomen;

gen str employedlab="Population" if year==2001;
gen str empMenlab="Men" if year==2001;
gen str empWomenlab="Women" if year==2001;

graph twoway 
	(connect employed year, ms(i) mlabel(employedlab) mlabposition(2))
	(connect empMen year, ms(i) mlabel(empMenlab) mlabposition(2))
	(connect empWomen year, ms(i) mlabel(empWomenlab) mlabposition(2)),
	title("Figure1: Employment-Population Ratio, 1970-2011", size(medium))
	subtitle("U.S. Civilian Noninstitutional Population",size(small))
	ytitle("Employment to Population Ratio")
	xtitle(" ""Year")
	xline(2007, lwidth(vvthin) lcolor(black))
	xline(2000, lwidth(vvthin) lcolor(black))
	legend(off);
graph export $dir\Lu\graph\EPOP_Figure1.pdf, replace;
*/

/*
use "C:\Users\Nicole\Desktop\Labor Supply RA\CPS extracts\MarchCPS\.dta files\datafordecomposition.dta", clear;
collapse employed [pweight=a_fnlwgt], by(year sex);
*/

/*Figure2*/
/*
use "$dir\Data\datafordecomposition.dta", clear;
drop if age==5;
collapse (mean) employed [pweight=a_fnlwgt], by(year);
save "$dir\Data\EPOPbyYear.dta", replace;

use "$dir\Data\datafordecomposition.dta", clear;
drop if age==5;
keep if lfp==1;
collapse (mean) unemployed, by(year);
save "$dir\Data\URbyYear.dta", replace;
*/
use "$dir\Data\EPOPbyYear.dta", clear;
merge year using "$dir\Data\URbyYear.dta", sort;

gen str employedlab="Employment-Population Ratio" if year==2001;
gen str unemployedlab="Unemployment Rate" if year==2001;
gen str lineslab="1989" if year==1989;
replace lineslab="1999" if year==1999;
replace lineslab="2007" if year==2007;
gen test=.66;

graph twoway 
	(connect employed year, ms(i) yaxis(1) mlabel(employedlab) mlabposition(4))
	(connect unemployed year, ms(i) lpattern(dash) yaxis(2) mlabel(unemployedlab) mlabposition(5)),
	title("Figure 2: Employment-Population Ratio and National Unemployment Rate", size(medium))
	subtitle("1989-2011, U.S. Civilian Noninstitutional Population Age16-64" ,size(small))
	ytitle("Employment-Population Ratio" "    ")
	ytitle("   " "Unemployment Rate", axis(2))
	xtitle(" ""Year" )
	xline(2007, lwidth(vvthin) lcolor(black) lpattern(shortdash))
	xline(1999, lwidth(vvthin) lcolor(black) lpattern(shortdash))
	xline(1989, lwidth(vvthin) lcolor(black) lpattern(shortdash))
	legend(off)
	xlabel(1989 1994 1999 2003 2007 2011);
graph export "$dir\EPOP_Figure2.eps", replace;



/*
/*Figure3*/
use $dir\Decomposition99.dta, clear;

gen str name99="EPOP using 1999 composition" if year==2004;
gen str Actname="Actual EPOP" if year==2006;

graph twoway 
	(connected EPOP99 year, ms(i) mlabel(name99) mlabposition(6))
	(connected EPOPActual year, ms(i) lpattern(dash) mlabel(Actname) mlabposition(12)),
	title("Figure3: Actual and Hypothetical Employment-Population Ratio",size(medium))
	subtitle("1989-2011, Fixed 1999 Demographic Composition")
	ytitle("Employment-Population Ratio" "    ")
	xtitle(" " "Year" )
	legend(off)
	note("Fixed-Composition calculated by fixing 1999 age, gender, education, and race proportions", size(vsmall));
graph export $dir\Lu\graph\EPOP_Figure3.pdf, replace;
log close;

